/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.event;

import azmalent.cuneiform.lib.util.BiomeUtil;
import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.ModTweaks;
import azmalent.terraincognita.common.registry.ModBiomes;
import azmalent.terraincognita.common.registry.ModEntities;
import azmalent.terraincognita.common.world.ModDefaultFeatures;
import azmalent.terraincognita.common.world.biome.BiomeEntry;
import azmalent.terraincognita.util.WorldGenUtil;
import net.minecraft.entity.EntityClassification;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.MobSpawnInfoBuilder;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BiomeHandler {
    public static void onLoadBiome(BiomeLoadingEvent event) {
        if (event.getName().func_110624_b().equals("terraincognita")) {
            BiomeHandler.initCustomBiome(event);
        } else if (event.getName().func_110624_b().equals("minecraft")) {
            BiomeHandler.applyVanillaBiomeTweaks(event);
        }
        RegistryKey biomeKey = BiomeUtil.getBiomeKey((ResourceLocation)event.getName());
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(event.getName());
        if (biome == null || BiomeUtil.hasAnyType((RegistryKey)biomeKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.END, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.VOID, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.DEAD})) {
            return;
        }
        MobSpawnInfoBuilder spawns = event.getSpawns();
        if (BiomeUtil.hasAnyType((RegistryKey)biomeKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.FOREST}) && BiomeUtil.hasNoneOfTypes((RegistryKey)biomeKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.DENSE})) {
            WorldGenUtil.addSpawner(spawns, ModEntities.BUTTERFLY, EntityClassification.AMBIENT, TIConfig.Fauna.butterflySpawnWeight.get(), 4, 8);
        }
        if (TIConfig.biomeBlacklist.contains((IForgeRegistryEntry)biome)) {
            return;
        }
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        if (BiomeUtil.hasNoneOfTypes((RegistryKey)biomeKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.SANDY, BiomeDictionary.Type.MESA, BiomeDictionary.Type.WASTELAND})) {
            ModDefaultFeatures.withHangingRoots(builder);
            if (BiomeUtil.hasNoneOfTypes((RegistryKey)biomeKey, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.COLD, BiomeDictionary.Type.SAVANNA, BiomeDictionary.Type.DRY})) {
                ModDefaultFeatures.withHangingMoss(builder);
            }
        }
        if (biomeKey == Biomes.field_185444_T) {
            ModDefaultFeatures.withSweetPeas(builder);
            return;
        }
        switch (WorldGenUtil.getProperBiomeCategory(biome)) {
            case PLAINS: {
                ModDefaultFeatures.withAppleTrees(builder);
                break;
            }
            case FOREST: {
                ModDefaultFeatures.withForestFlowers(builder);
                ModDefaultFeatures.withAppleTrees(builder);
                ModDefaultFeatures.withHazelTrees(builder);
                break;
            }
            case SWAMP: {
                ModDefaultFeatures.withSmallLilyPads(builder);
                ModDefaultFeatures.withCattails(builder);
                ModDefaultFeatures.withSwampReeds(builder);
                ModDefaultFeatures.withPeatAndMossyGravel(builder);
                if (BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) break;
                ModDefaultFeatures.withSwampFlowers(builder);
                break;
            }
            case SAVANNA: {
                ModDefaultFeatures.withSavannaFlowers(builder);
                break;
            }
            case EXTREME_HILLS: {
                if (BiomeDictionary.hasType((RegistryKey)biomeKey, (BiomeDictionary.Type)BiomeDictionary.Type.HOT)) break;
                ModDefaultFeatures.withAlpineFlowers(builder);
                break;
            }
            case JUNGLE: {
                ModDefaultFeatures.withJungleFlowers(builder);
                ModDefaultFeatures.withLotuses(builder);
                break;
            }
            case ICY: {
                ModDefaultFeatures.withCaribouMoss(builder);
            }
            case TAIGA: {
                ModDefaultFeatures.withArcticFlowers(builder);
            }
        }
    }

    public static void initCustomBiome(BiomeLoadingEvent event) {
        ResourceLocation id = event.getName();
        BiomeEntry biome = ModBiomes.ID_TO_BIOME_MAP.get(id);
        if (biome == null) {
            TerraIncognita.LOGGER.warn("Attempting to load unregistered biome " + id);
            return;
        }
        biome.initFeatures(event.getGeneration());
    }

    public static void applyVanillaBiomeTweaks(BiomeLoadingEvent event) {
        RegistryKey biome = BiomeUtil.getBiomeKey((ResourceLocation)event.getName());
        BiomeGenerationSettingsBuilder builder = event.getGeneration();
        if (biome == Biomes.field_76774_n || biome == Biomes.field_185445_W) {
            ModDefaultFeatures.withExtraTundraFeatures(builder);
            ModTweaks.addExtraTundraSpawns((MobSpawnInfo.Builder)event.getSpawns());
        } else if (biome == Biomes.field_235252_ay_) {
            ModDefaultFeatures.withWitherRoses(builder);
        }
    }
}

